CREATE OR REPLACE FORCE EDITIONABLE VIEW "AB03B"."ESTADISTICAS_PARLAMENTARIAS" ("TIPOPLAN", "TIPOPLANEU", "IDTIPO", "ANYO", "ID", "FECREG", "MES", "DS_O", "ACTIVIDAD", "ACTIVIDADEU", "ESTADO", "EXPEDIENTE", "IDPROVINCIA", "IDACTIVIDAD")
AS
  SELECT T08.DESC_ES_008 tipoPlan,
    T08.DESC_EU_008 tipoPlanEu,
    t08.id_008 idTipo,
    t10.ID_ANO_010 anyo,
    t10.ID_010 id,
    t10.FEC_REG_010 FECREG,
    EXTRACT( MONTH FROM t10.FEC_REG_010)MES,
    NORAPROV.DS_O,
    T54.DESC_ES_054 actividad,
    T54.DESC_EU_054 actividadEu,
    ESTADO_EXP_010 estado,
    T10.ID_PROV_010
    || '/'
    || T10.ID_ANO_010
    || '/'
    || lpad(T10.ID_010,5,'0') expediente,
    t10.ID_PROV_010 IDPROVINCIA,
    T10.ID_054_ACTIV
  FROM AB03B10T00 t10
  LEFT JOIN T17I.T17_PROVINCIA NORAPROV
  ON NORAPROV.ID = t10.ID_PROV_010
  LEFT JOIN AB03B54T00 T54
  ON T54.ID_054 = t10.ID_054_ACTIV
  INNER JOIN AB03B08T00 T08
  ON T08.ID_008=t10.ID_008_TIPO_PLAN;